// Design a filter using Butterworth polynomial for the following specifications:
//1.	Order : 7
//2.	Cut-off frequency : 2.5 kHz

// Version : Scilab 5.2.2
// Operating Syatem : Ubuntu 16.04 LTS

clc; 
clear;
xdel(winsid());
Fc =2500;                                                                       // Cut-off frequency
Fs =44100;                                                                      // Sampling frequency
N =7 ;                                                                          // Order of the filter
Fp = 2*Fc/Fs;                                                                   //Pass band edge frequency 
[Hz]=iir(N,'lp','butt',[Fp/2,0],[0,0])
[p,z,g]=iir(N,'lp','butt',[Fp/2,0],[0,0])
[Hw,w] = frmag(Hz ,256);

figure(1)
plot(2*w,abs(Hw)); 
xlabel("Digital Frequency  Normalized (w)")
ylabel("Magnitude")
title("Magnitude Response of Butterworth filter ")
xgrid(1)

[y,Fs]=wavread("tone1k.wav")                                                    // Reading the .wav file

outlow=filter(z,abs(p),y);

psd1=pspect(100,200,'re',y)
figure(2)
subplot(2,1,1)
plot(psd1)                                                                      //Plotting power spectral density of input
title('Input signal power spectral density')
xlabel('Frequency');
ylabel('Magnitude');

psd2=pspect(100,200,'re',outlow)
subplot(2,1,2)
plot(psd2)                                                                      //Plotting power spectral density of output
title('Filtered signal power spectral density')
xlabel('Frequency');
ylabel('Magnitude');

playsnd(outlow)





